/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.client.model;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Set;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.quark.content.mobs.entity.CrabEntity;

public class CrabModel
extends EntityModel<CrabEntity> {
    private float wiggleX = 0.0f;
    private float wiggleY = 0.0f;
    private float crabSize = 0.0f;
    public ModelRenderer group;
    public ModelRenderer body;
    public ModelRenderer rightClaw;
    public ModelRenderer leftClaw;
    public ModelRenderer rightLeg1;
    public ModelRenderer rightLeg2;
    public ModelRenderer rightLeg3;
    public ModelRenderer rightLeg4;
    public ModelRenderer leftLeg1;
    public ModelRenderer leftLeg2;
    public ModelRenderer leftLeg3;
    public ModelRenderer leftLeg4;
    public ModelRenderer rightEye;
    public ModelRenderer leftEye;
    private final Set<ModelRenderer> leftLegs;
    private final Set<ModelRenderer> rightLegs;

    public CrabModel() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.group = new ModelRenderer((Model)this);
        this.group.func_78793_a(0.0f, 0.0f, 0.0f);
        this.leftLeg4 = new ModelRenderer((Model)this, 0, 19);
        this.leftLeg4.field_78809_i = true;
        this.leftLeg4.func_78793_a(3.0f, 20.0f, -1.0f);
        this.leftLeg4.func_228301_a_(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.leftLeg4, 0.0f, 0.43633232f, 0.7853982f);
        this.leftLeg3 = new ModelRenderer((Model)this, 0, 19);
        this.leftLeg3.field_78809_i = true;
        this.leftLeg3.func_78793_a(3.0f, 20.0f, 0.0f);
        this.leftLeg3.func_228301_a_(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.leftLeg3, 0.0f, 0.21816616f, 0.7853982f);
        this.rightEye = new ModelRenderer((Model)this, 0, 11);
        this.rightEye.func_78793_a(0.0f, 0.0f, 0.0f);
        this.rightEye.func_228301_a_(-3.0f, -3.5f, -2.85f, 1.0f, 3.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.rightEye, -0.3926991f, 0.0f, 0.0f);
        this.rightLeg4 = new ModelRenderer((Model)this, 0, 19);
        this.rightLeg4.func_78793_a(-3.0f, 20.0f, -1.0f);
        this.rightLeg4.func_228301_a_(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.rightLeg4, 0.0f, -0.43633232f, -0.7853982f);
        this.rightClaw = new ModelRenderer((Model)this, 14, 11);
        this.rightClaw.func_78793_a(-3.0f, 20.0f, -4.0f);
        this.rightClaw.func_228301_a_(-3.0f, -2.5f, -6.0f, 3.0f, 5.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.rightClaw, 0.0f, 0.3926991f, -0.3926991f);
        this.leftLeg1 = new ModelRenderer((Model)this, 0, 19);
        this.leftLeg1.field_78809_i = true;
        this.leftLeg1.func_78793_a(3.0f, 20.0f, 2.0f);
        this.leftLeg1.func_228301_a_(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.leftLeg1, 0.0f, -0.43633232f, 0.7853982f);
        this.rightLeg2 = new ModelRenderer((Model)this, 0, 19);
        this.rightLeg2.func_78793_a(-3.0f, 20.0f, 0.9f);
        this.rightLeg2.func_228301_a_(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.rightLeg2, 0.0f, 0.21816616f, -0.7853982f);
        this.leftClaw = new ModelRenderer((Model)this, 14, 11);
        this.leftClaw.field_78809_i = true;
        this.leftClaw.func_78793_a(3.0f, 20.0f, -4.0f);
        this.leftClaw.func_228301_a_(0.0f, -2.5f, -6.0f, 3.0f, 5.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.leftClaw, 0.0f, -0.3926991f, 0.3926991f);
        this.rightLeg1 = new ModelRenderer((Model)this, 0, 19);
        this.rightLeg1.func_78793_a(-3.0f, 20.0f, 2.0f);
        this.rightLeg1.func_228301_a_(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.rightLeg1, 0.0f, 0.43633232f, -0.7853982f);
        this.body = new ModelRenderer((Model)this, 0, 0);
        this.body.func_78793_a(0.0f, 20.0f, 0.0f);
        this.body.func_228301_a_(-4.0f, -2.5f, -3.0f, 8.0f, 5.0f, 6.0f, 0.0f);
        this.leftEye = new ModelRenderer((Model)this, 0, 11);
        this.leftEye.func_78793_a(0.0f, 0.0f, 0.0f);
        this.leftEye.func_228301_a_(2.0f, -3.5f, -2.85f, 1.0f, 3.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.leftEye, -0.3926991f, 0.0f, 0.0f);
        this.leftLeg2 = new ModelRenderer((Model)this, 0, 19);
        this.leftLeg2.field_78809_i = true;
        this.leftLeg2.func_78793_a(3.0f, 20.0f, 0.9f);
        this.leftLeg2.func_228301_a_(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.leftLeg2, 0.0f, -0.21816616f, 0.7853982f);
        this.rightLeg3 = new ModelRenderer((Model)this, 0, 19);
        this.rightLeg3.func_78793_a(-3.0f, 20.0f, 0.0f);
        this.rightLeg3.func_228301_a_(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.rightLeg3, 0.0f, -0.21816616f, -0.7853982f);
        this.body.func_78792_a(this.rightEye);
        this.body.func_78792_a(this.leftEye);
        this.group.func_78792_a(this.body);
        this.group.func_78792_a(this.rightLeg1);
        this.group.func_78792_a(this.rightLeg2);
        this.group.func_78792_a(this.rightLeg3);
        this.group.func_78792_a(this.rightLeg4);
        this.group.func_78792_a(this.leftLeg1);
        this.group.func_78792_a(this.leftLeg2);
        this.group.func_78792_a(this.leftLeg3);
        this.group.func_78792_a(this.leftLeg4);
        this.group.func_78792_a(this.rightClaw);
        this.group.func_78792_a(this.leftClaw);
        this.leftLegs = ImmutableSet.of((Object)this.leftLeg1, (Object)this.leftLeg2, (Object)this.leftLeg3, (Object)this.leftLeg4);
        this.rightLegs = ImmutableSet.of((Object)this.rightLeg1, (Object)this.rightLeg2, (Object)this.rightLeg3, (Object)this.rightLeg4);
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void setRotationAngles(CrabEntity crab, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightLeg1.field_78808_h = -0.2618f + (-1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.rightLeg2.field_78808_h = -0.5236f + (-1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.rightLeg3.field_78808_h = -0.5236f + (-1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.rightLeg4.field_78808_h = -0.2618f + (-1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg1.field_78808_h = 0.2618f + (1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg2.field_78808_h = 0.5236f + (1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.leftLeg3.field_78808_h = 0.5236f + (1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg4.field_78808_h = 0.2618f + (1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.leftClaw.field_78795_f = 0.0f;
        this.rightClaw.field_78795_f = 0.0f;
        this.wiggleX = 0.0f;
        this.wiggleY = 0.0f;
        this.crabSize = crab.getSizeModifier();
        if (this.field_217114_e) {
            this.crabSize /= 2.0f;
        }
        if (crab.isRaving()) {
            float armRot;
            float crabRaveBPM = 31.25f;
            float freq = 20.0f / crabRaveBPM;
            float tick = ageInTicks * freq;
            float sin = (float)(Math.sin(tick) * 0.5 + 0.5);
            float legRot = sin * 0.8f + 0.6f;
            this.leftLegs.forEach(l -> {
                l.field_78808_h = legRot;
            });
            this.rightLegs.forEach(l -> {
                l.field_78808_h = -legRot;
            });
            float maxHeight = -0.05f;
            float horizontalOff = 0.2f;
            this.wiggleX = (sin - 0.5f) * 2.0f * maxHeight + maxHeight / 2.0f;
            float slowSin = (float)Math.sin(tick / 2.0f);
            this.wiggleY = slowSin * horizontalOff;
            this.leftClaw.field_78795_f = armRot = sin * 0.5f - 1.2f;
            this.rightClaw.field_78795_f = armRot;
        }
    }

    public void func_225598_a_(MatrixStack matrix, IVertexBuilder vb, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 1.5 - (double)this.crabSize * 1.5, 0.0);
        matrix.func_227862_a_(this.crabSize, this.crabSize, this.crabSize);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrix.func_227861_a_((double)this.wiggleX, (double)this.wiggleY, 0.0);
        this.group.func_228309_a_(matrix, vb, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_);
        matrix.func_227865_b_();
    }
}

